import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.*;

class TeglalapTests {
  private static Teglalap egyikTeglalap;
  private static Teglalap masikTeglalap;
  
  @BeforeAll
  static void setUpAll() {
    egyikTeglalap = new Teglalap(4.0, 4.0);
    masikTeglalap = new Teglalap(2.75034, 2.3699);
  }

  @Test
  void testTerulet() {
    assertTrue(egyikTeglalap.terulet() == 16.0, 
         "A teglalap terulete nem megfelelo");
    assertEquals(6.518030766, masikTeglalap.terulet(), 
         "A teglalap terulete nem megfelelo");
    
    /*FONTOS!!! 
     * double értékek összehasonlítására az előzőeket NE használjuk!!!*/
    assertEquals(6.52, masikTeglalap.terulet(), 0.01,
        "A teglalap terulete nem megfelelo");
  }

  @Test
  void testKerulet() {
    assertEquals(egyikTeglalap.kerulet(), 16.0, 0.001, 
        "A teglalap kerulete nem megfelelo");
  }
  
  @Test
  void testNegyzete() {
    assertTrue(egyikTeglalap.negyzete(), "Ez a teglalap negyzet");
    assertFalse(masikTeglalap.negyzete(), "Ez a teglalap nem negyzet");
  }
  
  @Test
  void testNagyobb() {
    assertSame(egyikTeglalap, Teglalap.nagyobb(egyikTeglalap, masikTeglalap), 
       "Nem a nagyobb teglalapot valasztottad");
  }
}
