import java.io.*;

public class IOStreamDemo {
  public static void main(String[] args) throws IOException {
    System.out.println("-- fajlbeolvasas soronkent --");
    BufferedReader brf =
      new BufferedReader(
        new FileReader("src/IOStreamDemo.java"));
    String s;
    StringBuilder f = new StringBuilder();
    while((s = brf.readLine())!= null) {
      f.append(s).append("\n");
    }
    brf.close();
 
    System.out.println("-- input memoriabol --");
    StringReader sr = new StringReader(f.toString());
    int c;
    while ((c = sr.read()) != -1) {
      System.out.print((char)c);
    }

    System.out.println("-- formatalt input memoriabol --");
    try {
      DataInputStream dis =
        new DataInputStream(
          new ByteArrayInputStream(f.toString().getBytes()));
      while (true) {
        System.out.print((char)dis.readByte());
      }
    } catch (EOFException e) {
      System.err.println("Adatfolyam vege");
    }

    System.out.println("-- fajl output --");
    BufferedReader brs =
      new BufferedReader(
        new StringReader(f.toString()));
    PrintWriter pw =
      new PrintWriter(
        new BufferedWriter(
          new FileWriter("IOStreamDemo.out")));
    int lineCount = 1;
    while ((s = brs.readLine()) != null) {
      pw.println(lineCount++ + ": " + s);
    }
    pw.close();

    System.out.println("-- random access fajl irasa/olvasasa --");
    RandomAccessFile raf =
      new RandomAccessFile("IOStreamDemo.dat", "rw");
    for(int i = 0; i < 5; i++) {
      raf.writeDouble(i*1.414);
    }
    raf.seek(3*8);
    raf.writeDouble(47.0001);
    raf.seek(0);
    for(int i = 0; i < 5; i++) {
      System.out.println(i + ". ertek: " + raf.readDouble());
    }
    raf.close();
  }
}
