import javax.swing.*;          
import java.awt.*;
import java.awt.event.*;

public class SwingApplication4 {
  private static JFrame frame = new JFrame("SwingApplication");
  private JPanel panel = new JPanel(new GridLayout(0,1));
  private JButton button = new JButton("Swing button");
  private String prefix = "Counter: ";
  private int clicks = 1;
  private JLabel label = new JLabel(prefix + "0");

  public SwingApplication4() {
    button.setMnemonic(KeyEvent.VK_W);
    button.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        label.setText(prefix + clicks++);
      }
    });
    panel.add(button);
    panel.add(label);
    panel.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
    frame.add(panel,BorderLayout.CENTER);
  }
  public static void main(String[] args) {
    SwingApplication4 app = new SwingApplication4();
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.pack();
    frame.setVisible(true);
  }
}
