import javax.swing.*;          
import java.awt.*;
import java.awt.event.*;

class OnButtonClick implements ActionListener {
  private String prefix;
  private int clicks;
  private JLabel label;
  public OnButtonClick(String prefix, int clicks, JLabel label) {
    this.prefix=prefix;
    this.clicks=clicks;
    this.label=label;
  }
  public void actionPerformed(ActionEvent e) {
    label.setText(prefix + clicks++);
  }
}

public class SwingApplication {
  private static JFrame frame = new JFrame("SwingApplication");
  private JPanel panel = new JPanel(new GridLayout(0,1));
  private JButton button = new JButton("Swing button");
  private String prefix = "Counter: ";
  private int clicks = 1;
  private JLabel label = new JLabel(prefix + "0");

  public SwingApplication() {
    button.setMnemonic(KeyEvent.VK_W);
    button.addActionListener(new OnButtonClick(prefix,clicks,label));
    panel.add(button);
    panel.add(label);
    panel.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
    frame.add(panel,BorderLayout.CENTER);
  }
  public static void main(String[] args) {
    SwingApplication app = new SwingApplication();
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.pack();
    frame.setVisible(true);
  }
}
