import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class RadioAndDialogDemo {
  static JDialog dialog = new JDialog();
  static JPanel panel = new JPanel(new BorderLayout());
  ButtonGroup group = new ButtonGroup();
  final String defaultCommand = "def";
  final String yesNoCommand = "yn";
  final String yesNoCancelCommand = "ync";

  public static void main(String[] args) {
    dialog.setTitle("Radio Dialog");
    dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
    new RadioAndDialogDemo();
    dialog.add(panel);
    dialog.pack();
    dialog.setVisible(true);
  }

  public RadioAndDialogDemo() {
    panel.add(createRadioButtonsPanel(), BorderLayout.NORTH);
    JButton button = new JButton("Valassz");
    panel.add(button, BorderLayout.CENTER);
    JLabel label = new JLabel("Valassz!", JLabel.CENTER);
    button.addActionListener(e -> {
      String command = group.getSelection().getActionCommand();
      if (command == defaultCommand) {
        JOptionPane.showMessageDialog(dialog, "Elso");
        label.setText("OK");
      } else if (command == yesNoCommand) {
        int n = JOptionPane.showConfirmDialog(dialog, "Masodik",
                     "Ujabb kerdes", JOptionPane.YES_NO_OPTION);
        if (n == JOptionPane.YES_OPTION) label.setText("Yes");
        else if (n == JOptionPane.NO_OPTION) label.setText("No");
      } else if (command == yesNoCancelCommand) {
        int n = JOptionPane.showConfirmDialog(dialog, "Harmadik",
                     "Ujabb kerdes", JOptionPane.YES_NO_CANCEL_OPTION);
        if (n == JOptionPane.YES_OPTION) label.setText("Yes");
        else if (n == JOptionPane.NO_OPTION) label.setText("No");
        else label.setText("Cancel");
      }
    });
    label.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
    panel.add(label, BorderLayout.SOUTH);
    panel.setBorder(BorderFactory.createEmptyBorder(20,20,5,20));
  }

  private JPanel createRadioButtonsPanel() {
    JRadioButton[] radioButtons = new JRadioButton[3];
    radioButtons[0] = new JRadioButton("ez az elso");
    radioButtons[0].setActionCommand(defaultCommand);
    radioButtons[1] = new JRadioButton("ez a masodik");
    radioButtons[1].setActionCommand(yesNoCommand);
    radioButtons[2] = new JRadioButton("ez pedig a harmadik");
    radioButtons[2].setActionCommand(yesNoCancelCommand);
    for (int i = 0; i < radioButtons.length; i++)
      group.add(radioButtons[i]);
    radioButtons[0].setSelected(true);
    JPanel panel = new JPanel();
    panel.setLayout(new BoxLayout(panel,BoxLayout.PAGE_AXIS));
    panel.add(new JLabel("A lista"));
    for (int i = 0; i < radioButtons.length; i++)
      panel.add(radioButtons[i]);
    return panel;
  }
}
