import java.lang.Iterable;
import java.util.Iterator;

class MyStack<E> implements Iterable<E> {
    class Link {
        E item;
        Link next;
        Link(E item, Link next) {this.item = item; this.next = next;}
    }
    Link top;

    void push(E item) {
        top = new Link(item, top);
    }
    public Iterator<E> iterator() {return new MyIterator<E>(top);}
}

class MyIterator<E> implements Iterator<E> {
    MyStack<E>.Link cur;

    MyIterator(MyStack<E>.Link top) {cur = top;}
    public boolean hasNext() {return cur != null;}
    public E next() {
        E item = cur.item;
        cur = cur.next;
        return item;
    }
}

public class GenericsForEach {
    public static void main(String[] args) {
        MyStack<Double> collection = new MyStack<>();
        collection.push(1.5);
        collection.push(2.5);
        collection.push(3.5);
        for(Double d : collection) {
            System.out.println(d);
        }
    }
}
