#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "image.h"
void split_ext(const char* filename, char stem[], char ext[]) {
    int lastDot = -1;
    int lastSlash = -1;
    int len = 0;
    for(int i = 0; filename[i] != '\0'; ++i, ++len) {
        if (filename[i] == '.') {
            if (i != lastSlash + 1)
              lastDot = i;
        } else if (filename[i] == '/') {
            lastDot = -1;
            lastSlash = i;
        }
    }
    stem[0] = '\0';
    ext[0] = '\0';
    if (lastDot < 0) {
        strncat(stem, filename, len);
    } else {
        strncat(stem, filename, lastDot);
        strncat(ext, filename + lastDot, len - lastDot);
    }
}

int main(int argc, char* argv[]) {
    if (argc<=3) {
        printf("Too few parameters\n");
        return EXIT_FAILURE;
    }
    char ext[4];
    char prefix[128];
    ext[0]='\0';
    prefix[0]='\0';

    split_ext(argv[1], prefix, ext);
    char output[256];
    output[0]='\0';

    strcat(output, argv[2]);
    if (ext[0] !='\0') {
        strcat(output, ext);
    }

    image *image = p_read(argv[1], ext);
    p_transform(argv[3], image);
    p_write(output, image);
    p_free(image);

    return 0;
}
