#include <CUnit/Basic.h>
#include <CUnit/CUnit.h>
#include <stdlib.h>
#include "../src/types.h"
#include "../src/pgm.h"

static imagePGM* pgm_images[] = {NULL, NULL, NULL};
#define MAX 10

imagePGM* alloc_pgm(int x, int y, int max) {
   imagePGM* image = (imagePGM*)malloc (sizeof(imagePGM));
   image->x = x;
   image->y = y;
   image->max = max;
   image->pixels = (int**) malloc (sizeof(int*)*image->y);
   for (int i=0; i<y;i++) {
     image->pixels[i]=(int*) malloc (sizeof(int)*image->x);
   }
   return image;
}

void init_with_const(imagePGM* img, const int value) {
  for(int i=0; i<img->y; i++)
    for(int j=0; j<img->x;j++)
      img->pixels[i][j] = value;
}

int init_suite() {
    pgm_images[0] = alloc_pgm(5, 6, 25);
    init_with_const(pgm_images[0], 1);

    int x=4, y=3, max=MAX; 

    int sample_img[][4] = {
        {1, 2, 3, 4}, 
        {5, 6, 7, 8},
        {9, 8, 7, 6}
    };
    pgm_images[1] = alloc_pgm(x, y, max);
    for(int i=0; i<y;i++)
      memcpy(pgm_images[1]->pixels[i], sample_img[i], sizeof(int)*x);

    return 0;
} 

int end_suite() {
   for (int n=0; pgm_images[n]; n++) {
	for(int i=0; i<pgm_images[n]->y;i++)
	   free(pgm_images[n]->pixels[i]);
	free(pgm_images[n]->pixels);
        free(pgm_images[n]);
        pgm_images[n] = NULL;
   }
   return 0;
}

void test_ppm_inverse(void)
{
    pgm_inverse(pgm_images[0]);
    CU_ASSERT(pgm_images[0]->max == 25);
    for(int i=0; i<pgm_images[0]->y; i++)
      for(int j=0; j<pgm_images[0]->x;j++)
        CU_ASSERT(pgm_images[0]->pixels[i][j] == 24);    

    pgm_inverse(pgm_images[1]);
    int expected[][4]={
       {MAX - 1, MAX - 2, MAX-3, MAX-4},
       {MAX - 5, MAX - 6, MAX - 7, MAX - 8},
       {MAX - 9, MAX - 8, MAX - 7, MAX - 6}
    };
    for(int i=0; i<3; i++)
      CU_ASSERT_EQUAL(0, memcmp(pgm_images[1]->pixels[i], expected[i], 4*sizeof(int)));
}

int main()
{
    CU_initialize_registry();
    CU_pSuite suite = CU_add_suite("InverseTestSuite", init_suite, end_suite);
    CU_add_test(suite, "test of ppm inverse", test_ppm_inverse);
    CU_basic_run_tests();
    CU_cleanup_registry();
    return CU_get_error();
}
