#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ppm.h"

void ppm_read(const char* filename, imagePPM* image) {
    FILE *fp = fopen(filename, "r");
    if (fp == NULL) {
        printf("Nem lehet megnyitni a %s fajlt\n", filename);
        exit( EXIT_FAILURE);
    }
    fscanf(fp, "P3\n");
    fscanf(fp, "%d %d %d", &image->x, &image->y, &image->max);

    image->pixels = (struct color**) malloc (image->y*sizeof(struct color*));
    for(int i=0;i<image->y;i++)
        image->pixels[i] = (struct color*) malloc(image->x*sizeof(struct color));

    for(int i=0; i<image->y; i++)
        for(int j=0; j<image->x; j++)
            fscanf(fp, "%d %d %d", &(image->pixels[i][j].r), &(image->pixels[i][j].g), &(image->pixels[i][j].b));

    fclose(fp);
}

void ppm_write(const char *filename, imagePPM* image) {
    FILE *fp = fopen(filename, "w");
    if (fp == NULL) {
        printf("Nem lehet megnyitni a %s fajlt\n", filename);
        exit(EXIT_FAILURE);
    }
    fprintf(fp, "P3\n%d %d %d\n", image->x, image->y, image->max);
    for(int i=0; i<image->y; i++) {
        for(int j=0; j<image->x; j++) {
            fprintf(fp, "%d %d %d%c", image->pixels[i][j].r, image->pixels[i][j].g, image->pixels[i][j].b, (j==image->x-1)?'\n':' ');
        }
    }
    fclose(fp);
}

void ppm_inverse(imagePPM* image) {
    printf("PPM inverse...\n");
    for(int i=0; i<image->y; i++) {
        for(int j=0; j<image->x; j++) {
            image->pixels[i][j].r = image->max - image->pixels[i][j].r;
            image->pixels[i][j].g = image->max - image->pixels[i][j].g;
            image->pixels[i][j].b = image->max - image->pixels[i][j].b;
        }
    }
}

void ppm_flip(imagePPM *image) {
    printf("PPM flip...\n");
    for(int i=0; i<image->y/2; i++) {
        for(int j=0; j<image->x; j++) {
			struct color tmp;
			tmp = image->pixels[i][j];
			image->pixels[i][j] = image->pixels[image->y-i-1][j];
			image->pixels[image->y-i-1][j] = tmp; 
			/*memcpy(&tmp, &(image->pixels[i][j]), sizeof(struct color));
			memcpy(&(image->pixels[i][j]), &(image->pixels[image->y-i-1][j]), sizeof(struct color));
			memcpy(&(image->pixels[image->y-i-1][j]), &tmp, sizeof(struct color)); */
        }
    }
}

/*void ppm_rotate(imagePPM* image) {
   
}*/

void ppm_free(imagePPM *image) {
    for(int i=0;i<image->y;i++)
        free(image->pixels[i]);
    free(image->pixels); // mi tortenik, ha ezt a sort kihagyjuk? es ha duplikaljuk?
    image->pixels = NULL;
}
