#include <stdio.h>
#include <stdlib.h>
#include "pgm.h"

void pgm_read(const char* filename, imagePGM* image) {
    FILE *fp = fopen(filename, "r");
    if (fp == NULL) {
        printf("Nem lehet megnyitni a %s fajlt\n", filename);
        exit( EXIT_FAILURE);
    }
    fscanf(fp, "P2\n");
    fscanf(fp, "%d %d %d", &image->x, &image->y, &image->max);

    image->pixels = (int**) malloc (image->y*sizeof(int*));
    for(int i=0;i<image->y;i++)
        image->pixels[i] = (int*) malloc(image->x*sizeof(int));

    for(int i=0; i<image->y; i++)
        for(int j=0; j<image->x; j++)
            fscanf(fp, "%d", &image->pixels[i][j]);

    fclose(fp);
}

void pgm_free(imagePGM *image) {
    for(int i=0;i<image->y;i++)
        free(image->pixels[i]);
    free(image->pixels);
    image->pixels = NULL;
}

void pgm_inverse(imagePGM *image) {
    printf("PGM inverse...\n");
    for(int i=0; i<image->y; i++) {
        for(int j=0; j<image->x; j++) {
            image->pixels[i][j] = image->max - image->pixels[i][j];
        }
    }
}

void pgm_write(const char *filename, imagePGM *image) {
    FILE *fp = fopen(filename, "w");
    if (fp == NULL) {
        printf("Nem lehet megnyitni a %s fajlt\n", filename);
        exit(EXIT_FAILURE);
    }
    fprintf(fp, "P2\n%d %d %d\n", image->x, image->y, image->max);
    for(int i=0; i<image->y; i++) {
        for(int j=0; j<image->x; j++) {
            fprintf(fp, "%d%c", image->pixels[i][j], (j==image->x-1)?'\n':' ');
        }
    }
    fclose(fp);
}
